"use client"

import { useState } from "react"
import { TopNav } from "@/components/layout/top-nav"
import { BottomNav } from "@/components/layout/bottom-nav"
import { Avatar, AvatarFallback, AvatarImage } from "@/components/ui/avatar"
import { Button } from "@/components/ui/button"
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs"
import { PostCard } from "@/components/posts/post-card"
import { Settings } from "lucide-react"
import Link from "next/link"
import type { Post } from "@/types/post"

const MOCK_USER_POSTS: Post[] = [
  {
    id: "1",
    author: {
      id: "current-user",
      username: "your_username",
      displayName: "Your Name",
      avatar: "/placeholder.svg?key=2sjn8",
    },
    content: "Just launched my first PWA! The feeling of seeing your code come to life is unmatched.",
    type: "thought",
    timestamp: "2h ago",
    likes: 24,
    comments: 5,
    isLiked: false,
  },
  {
    id: "2",
    author: {
      id: "current-user",
      username: "your_username",
      displayName: "Your Name",
      avatar: "/placeholder.svg?key=o92jq",
    },
    content: "Working on some new features today. Excited to share soon!",
    type: "thought",
    timestamp: "1d ago",
    likes: 18,
    comments: 3,
    isLiked: false,
  },
]

export default function ProfilePage() {
  const [posts, setPosts] = useState<Post[]>(MOCK_USER_POSTS)
  const [activeTab, setActiveTab] = useState("posts")

  const handleLike = (postId: string) => {
    setPosts(
      posts.map((post) =>
        post.id === postId
          ? { ...post, isLiked: !post.isLiked, likes: post.isLiked ? post.likes - 1 : post.likes + 1 }
          : post,
      ),
    )
  }

  return (
    <div className="min-h-screen pb-20 bg-background">
      <TopNav />
      <main className="max-w-2xl mx-auto">
        <div className="relative">
          <div className="h-32 bg-gradient-to-br from-primary/20 to-primary/5"></div>

          <div className="px-4 pb-4">
            <div className="flex items-end gap-4 -mt-16">
              <Avatar className="w-32 h-32 border-4 border-card">
                <AvatarImage src="/placeholder.svg?key=k43d9" />
                <AvatarFallback className="text-2xl">YN</AvatarFallback>
              </Avatar>

              <div className="flex-1 pb-2">
                <div className="flex items-center justify-between">
                  <div>
                    <h1 className="text-2xl font-bold text-foreground">Your Name</h1>
                    <p className="text-muted-foreground">@your_username</p>
                  </div>

                  <div className="flex gap-2">
                    <Button variant="outline" size="icon" asChild>
                      <Link href="/profile/settings">
                        <Settings className="w-5 h-5" />
                      </Link>
                    </Button>
                  </div>
                </div>
              </div>
            </div>

            <p className="mt-4 text-foreground">Software developer | Tech enthusiast | Coffee addict</p>

            <div className="flex gap-6 mt-4">
              <div>
                <span className="font-bold text-foreground">128</span>
                <span className="text-muted-foreground ml-1">Posts</span>
              </div>
              <button className="hover:underline">
                <span className="font-bold text-foreground">1.2K</span>
                <span className="text-muted-foreground ml-1">Followers</span>
              </button>
              <button className="hover:underline">
                <span className="font-bold text-foreground">842</span>
                <span className="text-muted-foreground ml-1">Following</span>
              </button>
            </div>
          </div>
        </div>

        <Tabs value={activeTab} onValueChange={setActiveTab} className="mt-6">
          <TabsList className="w-full justify-start border-b rounded-none h-auto p-0 bg-transparent">
            <TabsTrigger
              value="posts"
              className="rounded-none border-b-2 border-transparent data-[state=active]:border-primary data-[state=active]:bg-transparent"
            >
              Posts
            </TabsTrigger>
            <TabsTrigger
              value="media"
              className="rounded-none border-b-2 border-transparent data-[state=active]:border-primary data-[state=active]:bg-transparent"
            >
              Media
            </TabsTrigger>
            <TabsTrigger
              value="likes"
              className="rounded-none border-b-2 border-transparent data-[state=active]:border-primary data-[state=active]:bg-transparent"
            >
              Likes
            </TabsTrigger>
          </TabsList>

          <TabsContent value="posts" className="p-4 space-y-4">
            {posts.map((post) => (
              <PostCard key={post.id} post={post} onLike={handleLike} />
            ))}
          </TabsContent>

          <TabsContent value="media" className="p-4">
            <div className="grid grid-cols-3 gap-2">
              {[1, 2, 3, 4, 5, 6].map((i) => (
                <div key={i} className="aspect-square bg-secondary rounded-lg"></div>
              ))}
            </div>
          </TabsContent>

          <TabsContent value="likes" className="p-4 space-y-4">
            <p className="text-center text-muted-foreground py-8">No liked posts yet</p>
          </TabsContent>
        </Tabs>
      </main>
      <BottomNav />
    </div>
  )
}
