"use client"

import { useState } from "react"
import Link from "next/link"
import { Avatar, AvatarFallback, AvatarImage } from "@/components/ui/avatar"
import { MessageSquare } from "lucide-react"

interface Conversation {
  id: string
  user: {
    id: string
    name: string
    username: string
    avatar: string
  }
  lastMessage: string
  timestamp: string
  unread: boolean
}

const MOCK_CONVERSATIONS: Conversation[] = Array.from({ length: 12 }, (_, i) => ({
  id: `${i + 1}`,
  user: {
    id: `${i + 1}`,
    name: "Marvin McKinney",
    username: "marvin_m",
    avatar: "/young-man-professional-headshot-portrait.jpg",
  },
  lastMessage: "You: Thank you",
  timestamp: "7:36 pm",
  unread: false,
}))

export function ChatSidebar() {
  const [isCollapsed, setIsCollapsed] = useState(false)

  if (isCollapsed) {
    return null
  }

  return (
    <aside className="hidden lg:block fixed right-0 top-16 h-[calc(100vh-4rem)] w-[360px] bg-sidebar border-l border-sidebar-border">
      <div className="sticky top-0 bg-sidebar border-b border-sidebar-border px-4 py-3 z-10">
        <div className="flex items-center gap-2">
          <MessageSquare className="w-5 h-5 text-sidebar-primary" />
          <h2 className="text-base font-semibold text-sidebar-foreground">Messages</h2>
        </div>
      </div>

      <div className="h-[calc(100%-57px)] overflow-y-auto">
        {MOCK_CONVERSATIONS.map((conversation) => (
          <Link
            key={conversation.id}
            href={`/messages/${conversation.id}`}
            className="flex items-center gap-3 px-4 py-3 hover:bg-sidebar-accent transition-colors border-b border-sidebar-border"
          >
            <Avatar className="w-12 h-12 shrink-0">
              <AvatarImage src={conversation.user.avatar || "/placeholder.svg"} />
              <AvatarFallback className="bg-gradient-to-br from-indigo-500 to-purple-500 text-white text-sm">
                {conversation.user.name
                  .split(" ")
                  .map((n) => n[0])
                  .join("")}
              </AvatarFallback>
            </Avatar>

            <div className="flex-1 min-w-0">
              <div className="flex items-center justify-between gap-2 mb-1">
                <span className="text-sm font-medium text-sidebar-foreground truncate">{conversation.user.name}</span>
                <span className="text-xs text-muted-foreground shrink-0">{conversation.timestamp}</span>
              </div>
              <p className="text-xs text-muted-foreground truncate">{conversation.lastMessage}</p>
            </div>
          </Link>
        ))}
      </div>
    </aside>
  )
}
