"use client"

import { useTemplate } from "./template-provider"
import { Label } from "./ui/label"

const templates = [
  {
    id: "ocean" as const,
    name: "Ocean Breeze",
    description: "Cool blues and modern aesthetics",
    colors: ["#5b7bfa", "#8b5cf6", "#10b981"],
  },
  {
    id: "sunset" as const,
    name: "Sunset Vibes",
    description: "Warm oranges and peachy tones",
    colors: ["#ff6b35", "#ff8c42", "#ffb347"],
  },
  {
    id: "forest" as const,
    name: "Forest Calm",
    description: "Natural greens and earthy vibes",
    colors: ["#2d7a4f", "#4caf50", "#66bb6a"],
  },
  {
    id: "midnight" as const,
    name: "Midnight Purple",
    description: "Deep purples and mystical hues",
    colors: ["#a855f7", "#c084fc", "#d8b4fe"],
  },
]

export function TemplateSwitcher() {
  const { template, setTemplate } = useTemplate()

  return (
    <div className="space-y-4">
      <div>
        <Label className="text-base font-semibold">Design Template</Label>
        <p className="text-sm text-muted-foreground">Choose your preferred color scheme and visual style</p>
      </div>

      <div className="grid gap-3">
        {templates.map((t) => (
          <button
            key={t.id}
            onClick={() => setTemplate(t.id)}
            className={`relative flex items-start gap-4 p-4 rounded-lg border-2 transition-all ${
              template === t.id
                ? "border-primary bg-primary/5"
                : "border-border bg-card hover:border-primary/50 hover:bg-muted/50"
            }`}
          >
            <div className="flex gap-1">
              {t.colors.map((color, i) => (
                <div
                  key={i}
                  className="w-8 h-8 rounded-md border border-border shadow-sm"
                  style={{ backgroundColor: color }}
                />
              ))}
            </div>

            <div className="flex-1 text-left">
              <div className="font-semibold">{t.name}</div>
              <div className="text-sm text-muted-foreground">{t.description}</div>
            </div>

            {template === t.id && (
              <div className="absolute top-3 right-3">
                <svg className="w-5 h-5 text-primary" fill="currentColor" viewBox="0 0 20 20">
                  <path
                    fillRule="evenodd"
                    d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                    clipRule="evenodd"
                  />
                </svg>
              </div>
            )}
          </button>
        ))}
      </div>

      <div className="p-4 bg-muted/50 rounded-lg border border-border">
        <p className="text-sm text-muted-foreground">
          Your template choice will be saved and applied across all pages. You can change it anytime from settings.
        </p>
      </div>
    </div>
  )
}
