"use client"

import { motion } from "framer-motion"
import { Star } from 'lucide-react'
import { useEffect, useState } from "react"

const testimonials = [
  {
    name: "Sarah Johnson",
    role: "Content Creator",
    avatar: "/young-woman-headshot.png",
    quote: "MyPowerPost feels like what social media should be—authentic and connecting people!",
  },
  {
    name: "Marcus Chen",
    role: "Photographer",
    avatar: "/young-man-professional-headshot-portrait.jpg",
    quote: "The photo sharing is incredible. I've connected with fellow photographers worldwide.",
  },
  {
    name: "Emma Thompson",
    role: "Digital Artist",
    avatar: "/young-woman-cheerful-headshot-professional.jpg",
    quote: "A platform that values quality over quantity. My art gets genuine appreciation.",
  },
  {
    name: "Alex Rivera",
    role: "Developer",
    avatar: "/young-person-smiling-headshot-casual.jpg",
    quote: "Fast, clean, and no spam. Just pure social interaction. Exactly what I needed!",
  },
  {
    name: "Jordan Lee",
    role: "Writer",
    avatar: "/young-person-friendly-headshot-portrait.jpg",
    quote: "Best platform for sharing thoughts and connecting with other creators.",
  },
]

export default function TestimonialsSlider() {
  const [currentIndex, setCurrentIndex] = useState(0)

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentIndex((prev) => (prev + 1) % testimonials.length)
    }, 4000)
    return () => clearInterval(interval)
  }, [])

  const extendedTestimonials = [...testimonials, ...testimonials, ...testimonials]

  return (
    <div className="relative">
      <div className="overflow-hidden">
        <motion.div
          className="flex gap-6"
          animate={{
            x: `${-currentIndex * 50}%`,
          }}
          transition={{
            duration: 0.8,
            ease: "easeInOut",
          }}
        >
          {extendedTestimonials.map((testimonial, index) => (
            <div
              key={`${testimonial.name}-${index}`}
              className="min-w-[calc(50%-12px)] md:min-w-[calc(50%-12px)] flex-shrink-0"
            >
              <div className="p-8 rounded-3xl bg-gradient-to-br from-violet-500 via-purple-500 to-indigo-600 shadow-xl hover:shadow-2xl hover:scale-[1.02] transition-all duration-300 h-full">
                <div className="flex items-center gap-4 mb-6">
                  <img
                    src={testimonial.avatar || "/placeholder.svg"}
                    alt={testimonial.name}
                    className="w-16 h-16 rounded-full object-cover border-3 border-white shadow-md"
                  />
                  <div>
                    <div className="font-bold text-lg text-white">{testimonial.name}</div>
                    <div className="text-sm text-purple-100">{testimonial.role}</div>
                  </div>
                </div>
                <p className="text-white/95 leading-relaxed mb-4 text-lg font-medium">{testimonial.quote}</p>
                <div className="flex gap-1">
                  {[...Array(5)].map((_, i) => (
                    <Star key={i} className="w-5 h-5 fill-yellow-300 text-yellow-300" />
                  ))}
                </div>
              </div>
            </div>
          ))}
        </motion.div>
      </div>

      {/* Slider indicators */}
      <div className="flex items-center justify-center gap-2 mt-8">
        {testimonials.map((_, index) => (
          <button
            key={index}
            onClick={() => setCurrentIndex(index)}
            className={`transition-all duration-300 rounded-full ${
              index === currentIndex ? "w-8 h-2 bg-indigo-600" : "w-2 h-2 bg-gray-300 hover:bg-gray-400"
            }`}
            aria-label={`Go to testimonial ${index + 1}`}
          />
        ))}
      </div>
    </div>
  )
}
