export type FrindleStatus = "none" | "pending_sent" | "pending_received" | "connected" | "rejected"

export interface FrindleRequest {
  id: string
  senderId: string
  receiverId: string
  status: FrindleStatus
  createdAt: string
  updatedAt: string
}

export interface UserWithFrindleStatus {
  id: string
  name: string
  username: string
  avatar: string
  bio?: string
  followers: number
  frindleStatus: FrindleStatus
  mutualFrindles?: number
}
