export interface User {
  id: string
  username: string
  displayName: string
  avatar: string
}

export type Privacy = "public" | "private"

export interface Reply {
  id: string
  author: User
  content: string
  timestamp: string
  postId: string
}

export interface Post {
  id: string
  author: User
  content: string
  type: "thought" | "photo" | "music"
  timestamp: string
  likes: number
  comments: number
  isLiked: boolean
  imageUrl?: string
  musicUrl?: string
  musicTitle?: string
  musicArtist?: string
  privacy?: Privacy
  replies?: Reply[]
}
